#include "CRfePurLabFunctions.h"

#include <reader/QrfeRfePurReader>

CRfePurLabFunctions::CRfePurLabFunctions(QTextEdit* infoEdit, QWidget* parent)
	: ReaderTabWidget(tr("Lab Functions"), parent)
    , m_reader(0)
{
	ui.setupUi(this);
	setInfoEdit(infoEdit);

	connect(ui.waveAntennaPowerButton,		SIGNAL(toggled(bool)),
			this, 							  SLOT(testUnmodulatedWave(bool)));
	connect(ui.waveAttenuationSlider,	 	SIGNAL(valueChanged(int)),
			this, 							  SLOT(setWaveAttLabel(int)));


}

CRfePurLabFunctions::~CRfePurLabFunctions()
{

}

bool CRfePurLabFunctions::init(QrfeReaderInterface* reader)
{
	m_reader = qobject_cast<QrfeRfePurReader*>(reader);
	if( m_reader == 0 )
		return false;

	ulong sw_rev = m_reader->softwareRevision();
	sw_rev &= 0x0000FFFF;
	if(sw_rev < 0x0027)
		return false;

	ushort maxAtt = 0, currentAtt = 0;
	if(m_reader->getMaxAttenuation(maxAtt) == QrfeGlobal::RES_OK)
		ui.waveAttenuationSlider->setMaximum(maxAtt);

	if(m_reader->getCurrentAttenuation(currentAtt) == QrfeGlobal::RES_OK){
		ui.waveAttenuationSlider->setValue(currentAtt);
		setWaveAttLabel(currentAtt);
	}

	ui.antennaComboBox->clear();
	for(int i = 0; i < m_reader->antennaCount(); i++)
	{
		ui.antennaComboBox->addItem("Antenna #" + QString::number(i+1));
	}
	ui.antennaComboBox->setCurrentIndex(0);


	clearInfo();

	return true;
}

void CRfePurLabFunctions::deinit()
{
	if(m_reader != 0)
	{
		QrfeGlobal::Result res = m_reader->setAntennaPower(false);
		if(res == QrfeGlobal::RES_OK)
			ui.waveAntennaPowerButton->setChecked(false);
	}
	m_reader = 0;
}

void CRfePurLabFunctions::activated()
{
    if(m_reader == 0)
        return;
}


void CRfePurLabFunctions::testUnmodulatedWave(bool on)
{
	if(m_reader == 0)
		return;

	clearInfo();
	if(on == true)
	{
		if(m_reader->setWorkingAntenna(ui.antennaComboBox->currentIndex() + 1) != QrfeGlobal::RES_OK)
		{
			infoSetError("-- Could not select " + ui.antennaComboBox->currentText() + " --");
			return;
		}
		else
			infoAppend("-- Selected " + ui.antennaComboBox->currentText() + " --");

		ushort att = ui.waveAttenuationSlider->value();
		if(m_reader->setAttenuation(att) == QrfeGlobal::RES_OK)
		{
			infoAppend("-- Set attenuation to " + ui.waveAttenuationLabel->text() + " --");
		}
		else
		{
			infoSetError("-- Could not set Attenuation to " + ui.waveAttenuationLabel->text() + " --");
			return;
		}

		uint freq = ui.waveFrequencySpinBox->value() * 1000;
		QString freqStr = ui.waveFrequencySpinBox->text();
		if(m_reader->setFrequency(0, QList<uint>() << freq) == QrfeGlobal::RES_OK)
		{
			infoAppend("-- Set test frequency to " + freqStr + " --");
		}
		else
		{
			infoSetError("-- Could not set test frequency to " + freqStr + "MHz --");
			return;
		}
	}

	if(m_reader->setAntennaPower(on) != QrfeGlobal::RES_OK)
	{
		infoSetError("-- Could not set antenna power --");
		ui.waveAntennaPowerButton->setChecked(!on);
		return;
	}

	infoAppend("-- Set antenna power to " + QString((on)?"ON":"OFF") + " --");
	showOK();

	ui.waveFrequencySpinBox->setEnabled(!on);
	ui.waveAttenuationSlider->setEnabled(!on);

	ui.waveAntennaPowerButton->setText((on)?"OFF":"ON");
	ui.waveAntennaPowerButton->setIcon(QIcon(QString::fromUtf8((on)?":/button/stop":":/button/start")));
}

void CRfePurLabFunctions::setWaveAttLabel(int val)
{
	ui.waveAttenuationLabel->setText(QString::number(val) + " steps");
}

